{********************************************************************}
{                          V O I C E . P A S                         }
{*------------------------------------------------------------------*}
{ Task        : Demonstrates accessing the Creative Labs             }
{                  driver using the 'Text to Speech'                 }
{                  driver.                                           }
{*------------------------------------------------------------------*}
{ Author          : Michael Tischer / Bruno Jennrich                 }
{ Developed on  : 03/20/1994                                         }
{ Last update : 10/10/1994                                           }
{********************************************************************}
{$m 16000,16000,16000}
{$X+}                                    { Function results optional }

Uses SBUTIL,CTTS,ARGS,DOS;

var lpEntry : Longint;                          { Driver entry point }
    iGender,
    iTone,
    iVolume,
    iPitch,
    iSpeed    : Integer;
    Arguments : NArgStrings;
    ver       : Word;

{********************************************************************}
{          M A I N   P R O G R A M                                   }
{********************************************************************}
Begin
  iGender := 0;                                             { Gender }
  iGender := GetArg( '-FEMALE', _none, NIL, 0 );

  iTone := 0;                                                 { Tone }
  iTone := GetArg( '-TREBLE', _none, NIL, 0 );

  iVolume := 5;                                             { Volume }
  GetArg( '-VOL:', _int, @iVolume, 1 );

  iPitch := 5;                                               { Pitch }
  GetArg( '-PITCH:', _int, @iPitch, 1 );

  iSpeed := 5;                                               { Speed }
  GetArg( '-SPEED:', _int, @iSpeed, 1 );

  if GetNArg( '-', Arguments )  = 0 then
    Begin
      Writeln( 'Call: voice TEXT [ -FEMALE][ -TREBLE]' );
      Writeln( '[ -VOL:0-9][ -PITCH:0-9][ -SPEED:0-9 ]' );
      Halt( 0 );
    End;

  lpEntry := sb_LoadDriver( 'CTTS.DRV' );         { Load CTTS driver }

  if lpEntry = 0 then
    Writeln( 'Could not find "CTTS.DRV"!' )
  else
    Begin
      {-- Evaluate BLASTER environment variable -----------------------}
      if ctts_GetEnvSettings( lpEntry ) <> 0 then
        Writeln( 'Error in BLASTER environment variable' )
      else
        if ctts_Init( lpEntry ) <> 0 then       { Initialize driver }
          Writeln( 'Could not initialize CTTS' )
        else
          Begin
            ver := ctts_GetDrvVer( lpEntry );     { Get version number }
            Writeln( ' CTTS version: ', ver shr 8, '.', ver and $ff );
            ctts_SetSpeechParam( lpEntry,       { Set speech parameters }
                                 iGender,
                                 iTone,
                                 iVolume,
                                 iPitch,
                                 iSpeed );
            ctts_Say( lpEntry, Arguments[0] );  { Speak your piece... }
            ctts_Terminate( lpEntry );                        { and end }
          End;
      sb_UnloadDriver( lpEntry ); { Remove driver }
    End;
End.
